<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Assessment extends Model 
{

    protected $table = 'assessments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('department_id', 'tool_id', 'date_conducted', 'tool_version_major', 'assessment_type', 'assessment_class', 'user_id', 'tool_version_minor', 'tool_version_patch', 'tool_version_label', 'assessment_dats');

    public function department()
    {
        return $this->belongsTo('App/Models\Department');
    }

    public function tool()
    {
        return $this->belongsTo('App\Models\Tool');
    }

    public function reviewAssessments()
    {
        return $this->hasMany('App\Models\ReviewAssessment');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

}